/**
 * client.c
 *
 * Програма моделює роботу клієнта служби "Луна", що функціонує на базі потокових 
 * сокетів у комунікаційному домені AF_INET. IP-адреса сервера передається через аргумент
 * (і може задаватись як DNS-ім'я), номер порта задається константою SERVER_PORTNUM. 
 * Зв'язування клієнтського сокета з локальною та віддаленою адресами виконується за 
 * допомогою функції connect(). Підготувавши сокет, програма в циклі запитує від користувача
 * слово і передає його серверу; після чого отримує відповідь сервера, виводить її
 * у стандартний потік виведення результатів і запитує від користувача продовження роботи 
 * 
 */

#include "myecho.h"

#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>

int main(int argc, char *argv[])
{
    int s;
    struct sockaddr_in serv_addr;
    struct hostent *hp;
    char buf[BUFSIZE];
    
    // Перевіряє кількість аргументів
    if (argc != 2) {
        fprintf(stderr, "Invalid number of arguments\n");
        printf("Usage:\n");
        printf("%s <server_host_name>\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    // Виконує трасляцію DNS-імені сервера в IP-адресу
    // (якщо передана відразу IP-адреса, просто перетворює її
    // з текстового представлення в структуру типу hostent
    // (і повертає покажчик на цю структуру))
	hp = gethostbyname(argv[1]);
    if (hp == NULL) {
        fprintf(stderr, "gethostbyname(): %s\n", hstrerror(h_errno));
        exit(EXIT_FAILURE);
    }
    
    // Розміщує в структурі serv_addr адресу сервера
    memset(&serv_addr, 0, sizeof(serv_addr));
    memcpy(&serv_addr.sin_addr, hp->h_addr, hp->h_length);
    serv_addr.sin_family = hp->h_addrtype;
	// htons() переставляє байти свого аргумента
	// згідно з мережевим порядком
    serv_addr.sin_port = htons(SERVER_PORTNUM);	

    // Створює потоковий сокет в домені AF_INET
	s = socket(AF_INET, SOCK_STREAM, 0);
    if (s == -1) {
        perror("socket()");
        exit(EXIT_FAILURE);
    }
    
    // Встановлює з'єднання з сервером (і неявно зв'язує сокет s з локальною адресою)
    if (connect(s, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) == -1) {
        perror("connect()");
        exit(EXIT_FAILURE);
    }
    
    do {
        // Запитує від користувача слово
        printf("Request: ");
        // Розміщує слово в буфері
        scanf("%s", buf);
        // Передає повідомлення серверу
        if (send(s, buf, BUFSIZE, 0) == -1) {
            perror("send()");
            exit(EXIT_FAILURE);
        }

        // Очищає буфер
        buf[0] = '\0';
        // Отримує відповідь сервера
        if (recv(s, buf, BUFSIZE, 0) == -1) {
            perror("recv()");
            exit(EXIT_FAILURE);
        }
        // Виводить відповідь сервера
        printf("Answer: %s\n", buf);

        // Запитує від користувача продовження роботи
        printf("Another request? [y/n] ");
        scanf("%s", buf);
    } 
    while (!(strcmp(buf, "y") * strcmp(buf, "Y")));
    exit(EXIT_SUCCESS);
}
